<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 24. Jul. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * SpreadsheetFragment class file.
 * 
 * PHP versions 5.2 or better.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: SpreadsheetFragment.php 253 2007-08-01 14:14:10Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_table
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: SpreadsheetFragment.php 253 2007-08-01 14:14:10Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.3 - 24. Jul. 2007
 */

/**
 * 
 */
require_once 'OpenDocumentPHP/util/ODPElement.php';

/**
 * SpreadsheetFragment class.
 * 
 * Here we store the <office:text>...<office:text> part of the content tree.
 *  
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_table
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since 		0.5.3 - 24. Jul. 2007
 */
class SpreadsheetFragment extends ODPElement {

/**
	 * Constructor method.
	 * 
	 * @since 		0.5.3 - 24. Jul. 2007
	 */
    function __construct($elem=null) 
    {         
       if (is_null($elem)) {
           parent::__construct('office:spreadsheet', '', self::OFFICE);
       } else {
           parent::__construct($elem);         
       }
	}
}
?>
